<?php
/* --------------------------------------------------------------
  ServiceProvider.php 2020-02-21
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitEan;

use Doctrine\DBAL\Connection;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Properties\SellingUnitEan\Listener\OnGetSellingUnitEanEventListener;
use Gambio\Shop\Properties\SellingUnitEan\Repository\Reader\ReaderDatabase;
use Gambio\Shop\Properties\SellingUnitEan\Repository\Reader\ReaderInterface;
use Gambio\Shop\Properties\SellingUnitEan\Repository\Repository;
use Gambio\Shop\Properties\SellingUnitEan\Repository\RepositoryInterface;
use Gambio\Shop\Properties\SellingUnitEan\Service\ReadService;
use Gambio\Shop\Properties\SellingUnitEan\Service\ReadServiceInterface;
use Gambio\Shop\Properties\SellingUnitImages\Database\Repository\Helpers\CombisIdIdentifier;
use Gambio\Shop\Properties\SellingUnitImages\Database\Repository\Helpers\CombisIdIdentifierInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitEanEvent;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use PropertiesDataAgent;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\Properties\SellingUnitEan
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    protected $provides = [
        OnGetSellingUnitEanEventListener::class
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot()
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnGetSellingUnitEanEvent::class, OnGetSellingUnitEanEventListener::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->share(OnGetSellingUnitEanEventListener::class)
                        ->addArgument(ReadServiceInterface::class)
                        ->addArgument(CombisIdIdentifierInterface::class);
        $this->container->share(CombisIdIdentifierInterface::class, CombisIdIdentifier::class)->addArgument(
            PropertiesDataAgent::class
        );
        $this->container->share(PropertiesDataAgent::class);
        $this->container->share(ReadServiceInterface::class, ReadService::class)->addArgument(
            RepositoryInterface::class
        );
        $this->container->share(RepositoryInterface::class, Repository::class)->addArgument(ReaderInterface::class);
        $this->container->share(ReaderInterface::class, ReaderDatabase::class)->addArgument(Connection::class);
    }
}